<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title><?=$settings["site_name"]?></title>


  <?php if( $success ): ?>
<div class="alert alert-success"><?php echo $successText; ?></div>

<?php endif; ?>
<?php if( $error ): ?>
<div class="alert alert-danger"><?php echo $errorText; ?></div>
<?php endif; ?>
  </head>
  <body>
      
      
     <div class="main-container">
        <!-- Glassmorphic Card -->
        <div class="login-card">
            <div class="cat-animation">
                <div class="cat">
                    <div class="ear left-ear"></div>
                    <div class="ear right-ear"></div>
                    <div class="face">
                        <div class="eye left-eye"><div class="pupil"></div></div>
                        <div class="eye right-eye"><div class="pupil"></div></div>
                        <div class="nose"></div>
                        <div class="mouth"></div>
                    </div>
                </div>
            </div>
            <h1 class="heading">Welcome to Trsmmpanel</h1>
            <p class="subheading">Your Admin Panel</p>
            <form class="login-form" action="#" method="POST">
                <input type="username" name="username" placeholder="Username" required>
                <input type="password" name="password" placeholder="Password" required>
                <button type="submit">Login</button>
            </form>
        </div>
    </div>


     <style>
        /* General Reset */
body, html {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: 'Poppins', sans-serif;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    background: radial-gradient(circle, #1e3c72, #2a5298);
    overflow: hidden;
    color: #fff;
}

/* Main Container */
.main-container {
    width: 100%;
    max-width: 400px;
    display: flex;
    flex-direction: column;
    align-items: center;
}

/* Glassmorphic Card */
.login-card {
    background: rgba(255, 255, 255, 0.2);
    backdrop-filter: blur(10px);
    border-radius: 20px;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.2);
    padding: 20px;
    width: 100%;
    max-width: 350px;
    text-align: center;
    position: relative;
}

/* Cat Animation */
.cat-animation {
    position: relative;
    width: 120px;
    height: 120px;
    margin: 0 auto;
    overflow: hidden;
}

.cat {
    position: relative;
    width: 100%;
    height: 100%;
}

.ear {
    position: absolute;
    width: 30px;
    height: 50px;
    background: #FFD700;
    border-radius: 50% 50% 0 0;
}

.left-ear {
    top: -10px;
    left: 20px;
    transform: rotate(30deg);
}

.right-ear {
    top: -10px;
    right: 20px;
    transform: rotate(-30deg);
}

.face {
    position: absolute;
    width: 100px;
    height: 100px;
    background: #FFD700;
    border-radius: 50%;
    top: 20px;
    left: 10px;
    box-shadow: inset 0 -4px 6px rgba(0, 0, 0, 0.2);
}

.eye {
    position: absolute;
    width: 20px;
    height: 20px;
    background: #fff;
    border-radius: 50%;
    top: 30px;
}

.left-eye {
    left: 20px;
}

.right-eye {
    right: 20px;
}

.pupil {
    position: absolute;
    width: 8px;
    height: 8px;
    background: #000;
    border-radius: 50%;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    animation: blink 2s infinite;
}

@keyframes blink {
    0%, 100% { transform: translate(-50%, -50%); }
    50% { transform: translate(-50%, -70%); }
}

.nose {
    position: absolute;
    width: 12px;
    height: 8px;
    background: #000;
    border-radius: 50%;
    top: 60px;
    left: 50%;
    transform: translateX(-50%);
}

.mouth {
    position: absolute;
    width: 25px;
    height: 15px;
    border-bottom: 2px solid #000;
    border-radius: 50%;
    top: 70px;
    left: 50%;
    transform: translateX(-50%);
}

/* Heading */
.heading {
    font-size: 1.8rem;
    margin: 10px 0;
    color: #fff;
    background: linear-gradient(90deg, #ff7eb3, #ff758c);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.subheading {
    font-size: 1rem;
    margin-bottom: 20px;
    color: rgba(255, 255, 255, 0.7);
}

/* Form */
.login-form input {
    width: 100%;
    padding: 10px;
    margin: 10px 0px 0px -8px;
    border: none;
    border-radius: 5px;
    font-size: 1rem;
    color: #333;
    background: rgba(255, 255, 255, 0.9);
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
}

.login-form button {
    width: 100%;
    padding: 10px;
    border: none;
    border-radius: 5px;
    font-size: 1rem;
    background: linear-gradient(90deg, #ff758c, #ff7eb3);
    color: #fff;
    cursor: pointer;
    transition: 0.3s ease;
    margin-top: 10px;
}

.login-form button:hover {
    transform: scale(1.05);
    box-shadow: 0 6px 12px rgba(0, 0, 0, 0.2);
}


     </style>

<script>
document.addEventListener('mousemove', (e) => {
    const pupils = document.querySelectorAll('.pupil');
    pupils.forEach(pupil => {
        const rect = pupil.getBoundingClientRect();
        const x = e.clientX - rect.left - rect.width / 2;
        const y = e.clientY - rect.top - rect.height / 2;

        const angle = Math.atan2(y, x);
        const distance = Math.min(5, Math.sqrt(x * x + y * y));

        pupil.style.transform = `translate(${Math.cos(angle) * distance}px, ${Math.sin(angle) * distance}px)`;
    });
});

</script>

    
  </body>
</html>